# Hangman

This is a parallel Haskell program that simulates many rounds of the popular game 'Hangman.'<br>
Written by Anthony Pitts (aep2195). Some components of the initial, sequential implementation
were adapted from https://github.com/ralenda/haskellbook-hangman. 

### About

As my final project in Parallel Functional Programming, I implemented a version of the game "Hangman."<br>
My implementation uses AI heuristics to predict the next best letter choice in each round of the game. Broadly, it does this by using the heuristic of the "most common" possible letter. In other words, it will consider all words that have the same length as the word being guessed, and those with letters in the same positions as the correct letters already guessed. Of these words, it will select the letter that appears most frequently amongst them (excluding letters already guessed). The implementation uses two different pruning strategies (one when a correct letter was guessed, and one when an incorrect letter was guessed).<br>
Lastly, the program offers a parallel implementation, located inside the "parallel" folder. To read more about the specific
parallelization choices made and how they impacted the program's runtime and core usage, see the final report.

### Build
1) `cd sequential` or `cd parallel`
2) `stack build`

### Run
In ./sequential or ./parallel :<br>
Sequential: `stack exec hangman <dictionary_path> <wordsLength> <numberOfGames> --RTS -- +RTS -ls` <br> 
Parallel: `stack exec hangman <dictionary_path> <wordsLength> <numberOfGames> --RTS -- +RTS -ls -N2` <br>

- Where `<dictionary_path>` can be replaced with any absolute path to a newline-seperated dictionary of words.
- Where `<wordsLength>` can be replaced with any integer specifying the length of the words being guessed. <br>
- Where `<numberOfGames>` can be replaced with any positive integer specifying the number of games to simulate. <br>

Sequential example: `stack exec hangman data/large_dict.txt 7 50 --RTS -- +RTS -ls` <br> 
Parallel example: `stack exec hangman data/large_dict.txt 7 50 --RTS -- +RTS -ls -N2` <br>

### Test Suite

In ./sequential or ./parallel : `stack test` <br> 

### Threadscope
To see program events in Threadscope: 
1) `stack install threadscope`
2) `threadscope hangman.eventlog`